/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Hong 01/15/07 RESET_USER_VARIABLES											*
 * Hong 02/26/07 FIX_SHOULD_NOT_SORT_VARIABLE									*
 * Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE								*
 * Hong 03/23/07 v8.0588 MORE_INFO_FOR__IMP_WIZ_SUPPORT_REIMPORT				*
 * Hong 03/30/07 v8.0593 ROLLBACK_CODE_TO_SORT_VARIABLE_BY_FILENAME_HEADER		*
 *	Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT				*
 *	Hong 04/12/07 v8.0599 ADD_REIMPORT_SUPPORT_FOR_IMP_WIZ						*
 *	Sim 05-08-2007 FIX_DEFAULT_SHOULD_NOT_CHAGNE_DESIGNATIONS					*
 *	Sim 05-24-2007 KEEP_RANGE_INFO_FOR_OUTPUT									*
 *	Sim 06-25-2007 UPDATE_ORGANIZER												*
 *	AW 08/15/07 NEED_CHECK_PGTARGET_IN_IMPORTING								*
 *	Hong 09/10/07 v8.0699b FIX_FAIL_ADD_NEW_COL_TO_CORRECT_WORKSHEET			*
 *	Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO									*
 *	Hong 12/06/07 v8.0762 IMPORT_SUPPORT_RELATIVE_PATH_FOR_REIMPORT_SAMPLE_REQUIREMENT
 *	Hong QA80-10989 IMPORT_SHOULD_STOP_AND_TAKE_NO_EFFECT_IF_COL_LOCKED			*
 *	Hong 0314/08 QA80-10989 FIX_LOCK_RANGE_CHECK_EXPAND_FOR_ONE_COLUMN			*
 *	Hong 14/05/08 v8.0862b FIX_IMP_WIZ_NOT_AUTOSIZE_WORKSHEET_AS_OTHER_IMP_TOOL	*
 * EJP 2008-06-09 v8.0881 EXECUTE_SCRIPT_IN_IMPORT_FILTER_AFTER_UPDATING_PAGE_INFO
 *	Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
 *	Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
 *	Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME			*
 *	Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
 *	Hong 08/19/08 v8.0925 IMP_WIZ_VARIABLE_SHOULD_KEEP_AS_STRING_TYPE			*
 *	Hong 01/09/09 v8.0995 CORRECT_IMPASC_ERROR_RETURN_CHECKING					*
 *	Hong 02/16/09 QA80-13120 ROLL_BACK_OLD_CODE_TO_SPEEDUP_SET_PAGE_VAIRABLE_INFO
 *	Jasmine 08/14/09 QA81-14148 AUTOSIZE_BETTER_HEIGHT_AND_WIDTH				*
 *	Folger 08/19/09 QA80-14148 SUPPORT_SKIP_SPECIFIC_LABELS_WHEN_AUTOSIZE_WKS	*
 *	Jasmine 08/21/09 QA81-14148 AUTOSIZE_SKIP_COL_HEADER						*
 *	Hong 08/26/09 QA80-13839-P1 FIX_IMPASC_REIMPORT_APPEND_REDUNDANT_FILENAME_INTO_PG_COMMENT
 *	Hong 08/31/09 QA80-12899 IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE			*
 *	Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC							*
 *	Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////
#include <oFilterUtils.h>// Hong 8/21/06 CLEAN_HEADER_FILE
#include "fu_utils.h" /// Hong 8/18/06 REMOVE_TO_FU_UTILS
#include "import_utils.h"/// Hong 9/26/06 ADD_VARIABLE_TO_PAGE_INFO
#include "IWBase.h"
#include "ImpWiz.h"


////////////////////////////////////////////////////////////////////////////////////
/// AW 08/03/06 MORE_ON_IW_IMPORT
///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
/*
#define fuIsAppendFileNameToWorkBookComments(_tn)	fuGetFlag(&_tn, AI_FLAG_FNAME_TO_WKBK_COMMENTS, FALSE)
#define fuIsAppendFileNameWithoutPath(_tn)			fuGetFlag(&_tn, AI_FLAG_REMOVE_FNAME_PATH, FALSE)
*/
///---END REMOVE_TO_FU_UTILS

///---Sim 08-08-2006 SPECIAL_FORMATS_IN_ASCII
/*
/// AW 08/06/06 CHECK_IW_FILTER
static BOOL fuGetASCIMP(TreeNode& trFilter, ASCIMP& ascimp, BOOL bGetCommonNode = FALSE)
{
	//_MSG_INT(fuGetASCIMP, ascimp.iDelimited)
	
	TreeNode trASCIMP = trFilter.GetNode("ASCIMP");
	if( trASCIMP )
	{
		ascimp = trASCIMP;
		if( bGetCommonNode )
		{
			ascimp.iMode = trFilter.Common.ImportMode.nVal;
			ascimp.iRenameWks = trFilter.Common.RenameWks.nVal;
			ascimp.iPartial = trFilter.Common.Partial.nVal;
			ascimp.iPartialC1 = trFilter.Common.PartialC1.nVal;
			ascimp.iPartialC2 = trFilter.Common.PartialC2.nVal;
			ascimp.iPartialR1 = trFilter.Common.PartialR1.nVal;
			ascimp.iPartialR2 = trFilter.Common.PartialR2.nVal;
			ascimp.iSkipRows = tree_node_get_int(trFilter.Common.SkipRows, 0); /// EJP 07-23-2003 v7.0631 QA70-4575 ADD_SKIPROWS_TO_BINIMP
			/// EJP 07-19-2004 v8.0911 QA70-6555 SUPPORT_WORKBOOK_IMPWIZ
			#if _OC_VER >= 0x0800
			ascimp.flags = tree_node_get_int(trFilter.Common.Flags, 0);
			#endif // _OC_VER >= 0x0800
			/// end SUPPORT_WORKBOOK_IMPWIZ
		}
		return TRUE;
	}
	return FALSE;
}
static BOOL fuGetCustomDate(TreeNode& tnFilter, string& strFormat)
{
	ASCIMP ai;
	if( fuGetASCIMP(tnFilter, ai) )
	{
		strFormat = ai.szDateFormat;
		strFormat.TrimLeft();
		strFormat.TrimRight();
		return (!strFormat.IsEmpty());
	}
	return FALSE;
}
/// END CHECK_IW_FILTER
*/
///---END SPECIAL_FORMATS_IN_ASCII

///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
/*
static BOOL fuGetVarsRoot(TreeNode& tnFilter, TreeNode& tnVarsRoot)
{
	if( !tnFilter )
		return FALSE;
	if( !tnFilter.Variables )
		tnFilter.AddNode("Variables");
	tnVarsRoot = tnFilter.Variables;
	return TRUE;
}
static BOOL fuIsVarInPageInfo(TreeNode& tnFilter)
{
	TreeNode tnVars;
	if( !fuGetVarsRoot(tnFilter, tnVars) )
		return FALSE;
	if( !tnVars || !tnVars.PageInfo )
		return FALSE;
	return tnVars.PageInfo.nVal;
}
*/
///---END REMOVE_TO_FU_UTILS

static int HeaderVariablesToPageInfo(Page &pgTarget, StringArray& saVarNames, StringArray& saVarValues)
{
	if( !pgTarget )
		return 1;
	/// Hong 02/16/09 QA80-13120 ROLL_BACK_OLD_CODE_TO_SPEEDUP_SET_PAGE_VAIRABLE_INFO
	/// Hong 06/26/08 v.80891e CENTRALIZE_CODE
	pgTarget.Info.Add("User");
	pgTarget.Info.User.AddSection("Variables");
	
	string str;
	
	using var = pgTarget.Info.User.Variables;    
	for( int n = 0; n < saVarNames.GetSize(); n++ )
		var.AddString(saVarNames[n], saVarValues[n]);
	/*
	ASSERT( saVarNames.GetSize() == saVarValues.GetSize() );
	int			nNodeType = TRGP_STR; /// Hong 08/19/08 v8.0925 IMP_WIZ_VARIABLE_SHOULD_KEEP_AS_STRING_TYPE
	for ( int n = 0; n < saVarNames.GetSize(); n++ )
	{		
		/// Hong 08/19/08 v8.0925 IMP_WIZ_VARIABLE_SHOULD_KEEP_AS_STRING_TYPE
		//page_set_info_var_value(pgTarget, saVarNames[n], saVarValues[n]);		
		page_set_info_var_value(pgTarget, saVarNames[n], saVarValues[n], NULL, &nNodeType);
		/// end IMP_WIZ_VARIABLE_SHOULD_KEEP_AS_STRING_TYPE
	}
	/// end CENTRALIZE_CODE
	*/
	/// end ROLL_BACK_OLD_CODE_TO_SPEEDUP_SET_PAGE_VAIRABLE_INFO

	return 0;
}
/// END MORE_ON_IW_IMPORT

/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
static bool HeaderVariablesToUserDefinedParameter(const DataRange& dr, vector<string>& saVarNames, vector<string>& saVarValues)
{
	if ( !dr )
		return false;
	
	Worksheet		wks;
	int				nC1, nC2;
	for ( int nIndexSubRange = 0; nIndexSubRange < dr.GetNumData(); nIndexSubRange++ )
	{		
		if ( !dr.GetRange(wks, nC1, nC2, nIndexSubRange) || !wks )
			continue;
		
		if ( -1 == nC2 )
			nC2 = wks.GetNumCols() - 1;
				
		for ( int ii = nC1; ii <= nC2; ii++ )
		{
			Column		cc(wks, ii);
			ASSERT(cc);
			set_user_parameters(cc, saVarNames, saVarValues);
		}
	}
	return true;
}
/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS

///---Sim 08-17-2006 REMOVE_TO_FU_UTILS
/*
static bool fuGetPostImportScript(TreeNode &trFilter, string &strScript)
{
	if( !trFilter.Common.PostImportScript )
		return false;
	strScript = trFilter.Common.PostImportScript.strVal;
	
	/// EJP 12-20-2004 v8.0177 UTIL_FUNC_CONV_CR_TO_CRLF
	///	// The string went into the filter with CR-LF combo, but the tree or XML
	///	// code strips the CR char.  Here I will replace all LF chars with CR-LF combo.
	///	// First check if combo is there in case tree or XML behavior changes.
	///	if( -1 == strScript.Find("\r\n") ) // If CR-LF combo is not found
	///		strScript.Replace("\n", "\r\n"); // Replace LF with CR-LF
	check_convert_CR_str_to_CRLF(strScript);
	/// end UTIL_FUNC_CONV_CR_TO_CRLF
	
	return true;
}
///---Sim 08-04-2006 COMMON_FUNC_ON_BASE_CLASS
string fuGetDesignations(TreeNode& trFilter)
{
	string str;
	if( trFilter.Common.ColDesignations )
		str = trFilter.Common.ColDesignations.strVal;
	return str;
}
string fuGetFormats(TreeNode& trFilter)
{
	string str;
	if( trFilter.Common.ColFormats )
		str = trFilter.Common.ColFormats.strVal;
	return str;
}
BOOL fuGetRepetitive(TreeNode& trFilter)
{
	if( trFilter.Common.ColDesignationsRepetitive )
		return trFilter.Common.ColDesignationsRepetitive.nVal;
	return FALSE; // default is off
}
*/
///---END REMOVE_TO_FU_UTILS

// Get the worksheet columns' formats or designations setting, it actually modifies the current settings according filter setting
// This function is called when need to change part of the current settings according filter.
///---Sim 08-09-2006 PARTIAL_DESIGNATIOINS
//static int GetColumnSetting(string &strSetting, LPCSTR lpcszFilterSetting, int nTargetCol, int nNumCols, BOOL bRepetitive)
static int GetColumnSetting(string &strSetting, LPCSTR lpcszFilterSetting, int nTargetCol, int nNumCols, BOOL bRepetitive, int nFirstSourceCol) // = 0)
///---END PARTIAL_DESIGNATIOINS
{
	if( strSetting.IsEmpty() )
		return 1; // Error

	// If the filter is NULL, just use strSetting
	if( !lpcszFilterSetting )
		return 0; // Success
	
	int nFilterLen = lstrlen(lpcszFilterSetting);
	///---Sim 05-08-2007 FIX_DEFAULT_SHOULD_NOT_CHAGNE_DESIGNATIONS
	if ( 0 == nFilterLen )
		return 0;
	///---END FIX_DEFAULT_SHOULD_NOT_CHAGNE_DESIGNATIONS

	int nSettingLen = strSetting.GetLength();
	
	///---Sim 08-09-2006 PARTIAL_DESIGNATIOINS
	/*
	if( nSettingLen - nTargetCol < nFilterLen )
		return 1;
	*/
	///---END PARTIAL_DESIGNATIOINS

	int nPos = 0;
	///---Sim 08-09-2006 PARTIAL_DESIGNATIOINS
	int nCurPosInFilterStr = 0;
	if ( 0 != nFilterLen ) ///---Sim 08-30-2006 AVOID_TO_DIV_ZERO
		nCurPosInFilterStr = nFirstSourceCol % nFilterLen;
	///---END PARTIAL_DESIGNATIOINS
	
	
	LPSTR lpszSetting = strSetting.GetBuffer(nSettingLen);
	LPSTR lpsz = lpszSetting + nTargetCol;
	
	while( nPos < nNumCols )
	{
		if( nCurPosInFilterStr >= nFilterLen )
			nCurPosInFilterStr = bRepetitive ? 0 : nFilterLen - 1;

		*(lpsz + nPos) = *(lpcszFilterSetting + nCurPosInFilterStr);
		
		nPos++;
		nCurPosInFilterStr++;
	}
	strSetting.ReleaseBuffer();
	
	return 0;
}

///---END COMMON_FUNC_ON_BASE_CLASS


////////////////////////////////////////////////////////////////////////////////////
// Start your functions here.
virtual int ImpWiz::Execute(Layer& lyTarget, int nIndexFile, string& strFileName, TreeNode& tnInfo, TreeNode& trFilter)
{
	/// Hong 08/31/09 QA80-12899 IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE
	if ( fuIsKeepTargetColFormat(trFilter) )
		fuSetInt(trFilter, IDE_ASCIMP_AUTOCOLTYPES, 0);
	/// end IMP_WIZ_SUPPORT_KEEP_COL_FMTS_IN_TEMPLATE
	int nRet;
	/// Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII	
	//Page pgData;
	//if ( lyTarget )
		//lyTarget.GetParent(pgData);
	/// end FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
	/// AW 08/03/06 MORE_ON_IW_IMPORT
	if ( nRet = PrepareWksColsForImport(lyTarget, trFilter) )
		return nRet;
	
	/// Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII	
	// Rename in low level is ASCII special, should NOT put here
	/////---Sim 02-03-2007 ADD_AUTO_RENAME
	//// not rename in low levle, it will centralize at framework
	//bool bRenameWks, bRenameWkBk, bRenameWkBkComm, bRenameColComm, bRenameWksWithVar, bRenameWkbkWithVar;
	//fuDisableAllRename(trFilter, &bRenameWks, &bRenameWkBk, &bRenameWkBkComm, &bRenameColComm, &bRenameWksWithVar, &bRenameWkbkWithVar);
	/// end FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
		
	///---Sim 08-07-2006 HANDLE_EXECUTE_ERR
	//IWBase::Execute(lyTarget, nIndexFile, strFileName, tnInfo, trFilter);
	if ( nRet = IWBase::Execute(lyTarget, nIndexFile, strFileName, tnInfo, trFilter) )
		return nRet;
	///---END HANDLE_EXECUTE_ERR

	/// Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
	//fuSetAllRename(trFilter, &bRenameWks, &bRenameWkBk, &bRenameWkBkComm, &bRenameColComm, &bRenameWksWithVar, &bRenameWkbkWithVar);
	/////---END ADD_AUTO_RENAME	
	//SetPageLayer(pgData, lyTarget, trFilter, strFileName, tnInfo);
	/// end FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
	
	return IMPERR_NONE;
}

virtual void ImpWiz::GenerateImpInfo(string& strFileName, Page& pgTarget, TreeNode& trFilter, TreeNode& trImpInfo, int& nFNodeIndex) 
{
	/// Hong 04/12/07 v8.0599 ADD_REIMPORT_SUPPORT_FOR_IMP_WIZ
	//impinfo_InitTree(pgTarget, fuGetImportMode(trFilter));
	//impinfo_GetLastFileNode(pgTarget, m_trFile);
	if( !m_bReimport ) // default
	{
		impinfo_InitTree(pgTarget, fuGetImportMode(trFilter));
		impinfo_GetLastFileNode(pgTarget, m_trFile);
	}
	else //when reimport, find out the file tree, and update it
	{
		///---Sim 03-12-2007 MORE_WORK_ON_ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
		//Datasheet dsTemp;
		//int c1 = 0, c2 = -1;
		DataRange dr;
		//if( trRange && trRange.GetDataRange(dr) )
			//dr.GetRange(dsTemp, c1, c2);
		TreeNode trRange = tree_get_node_by_tagname(trImpInfo, "DataRange", true);
		
		if ( trRange )
			dr = get_and_check_range(trRange, pgTarget.GetName());
		///---END MORE_WORK_ON_ONLY_UPDATE_BINARY_INFO_WHEN_REIMPORT
		
		nFNodeIndex = getFileInfoByRange(m_trFile, dr);
		
		if( nFNodeIndex < 0 )
			return ;
		
		m_trFile.RemoveChildrenWithPrefix();
	}
	/// end ADD_REIMPORT_SUPPORT_FOR_IMP_WIZ
	
	///---Sim 03-07-2007 CHANGE_POSITION_OF_DATA_RANGE_TREE remove
	TreeNode trRange = tree_get_node_by_tagname(trImpInfo, "DataRange", true);
	//impinfo_FileInfoToFileNode(m_trFile, strFileName, m_iFilterType);
	///---Sim 03-11-2007 QA80-9435 CENTRALIZE_RANGE_TREE_BOTH_ON_VC_AND_OC
	// temporary fix
	TreeNode trNewRange = trRange;
	if ( trNewRange.Datarange )
		trNewRange = trNewRange.Datarange;
	/// Hong 12/06/07 v8.0762 IMPORT_SUPPORT_RELATIVE_PATH_FOR_REIMPORT_SAMPLE_REQUIREMENT
	//impinfo_FileInfoToFileNode(m_trFile, strFileName, m_iFilterType, trNewRange);
	string strOriginFileName = strFileName;
	TreeNode trOriginFname = tree_get_node_by_tagname(trImpInfo, "OriginFileName", true);
	if ( trOriginFname )
		strOriginFileName = trOriginFname.strVal;
	impinfo_FileInfoToFileNode(m_trFile, strOriginFileName, m_iFilterType, trNewRange);
	/// end IMPORT_SUPPORT_RELATIVE_PATH_FOR_REIMPORT_SAMPLE_REQUIREMENT
	///---END QA80-9435 CENTRALIZE_RANGE_TREE_BOTH_ON_VC_AND_OC
	///---Sim 05-24-2007 KEEP_RANGE_INFO_FOR_OUTPUT
	Tree trRangeBak;
	trRangeBak.Replace(trRange);
	///---END KEEP_RANGE_INFO_FOR_OUTPUT
	trRange.Remove(); // trRange has been save into Info tree, no need again.
	///---END CHANGE_POSITION_OF_DATA_RANGE_TREE remove

	TreeNode trNode = trImpInfo.FirstNode;
	while( trNode )
	{
		m_trFile.AddNode(trNode, true);
		trNode = trNode.NextNode;
	}
	
	///---Sim 05-24-2007 KEEP_RANGE_INFO_FOR_OUTPUT
	trImpInfo.AddNode(trRangeBak);
	///---END KEEP_RANGE_INFO_FOR_OUTPUT
	
	/// Hong 03/23/07 v8.0588 MORE_INFO_FOR__IMP_WIZ_SUPPORT_REIMPORT
	// copy from fu_utlis.c
	if( trFilter && trFilter.IsValid() )
	{
		if(trFilter.FileName)	
		{
			m_trFile.Info.FilterFileName.strVal = trFilter.FileName.strVal; 
			m_trFile.Info.FilterFileName.SetAttribute(STR_LABEL_ATTRIB, _L("Filter File Name"));/// Hong 11/24/09 LOCALIZE_IMPORT_INFO
		}
			
		TreeNode trFilterInfo = m_trFile.AddNode("FilterInfo");
		trFilterInfo.SetAttribute(STR_LABEL_ATTRIB, _L("Filter Info"));		//------ Folger 11/17/07 LOCALIZE_IMPORT_FILE_INFO
		TreeNode trNode1 = trFilter.FirstNode;
		while( trNode1 )
		{
			trFilterInfo.AddNode(trNode1, true);
			trNode1 = trNode1.NextNode;
		}
	}
	///end MORE_INFO_FOR__IMP_WIZ_SUPPORT_REIMPORT
	//SetDataRange(pgTarget, trImpInfo);///---Sim 03-07-2007 CHANGE_POSITION_OF_DATA_RANGE_TREE remove
}

///---Sim 08-04-2006 COMMON_FUNC_ON_BASE_CLASS
///---Sim 08-08-2006 PARTIAL_DESIGNATIOINS
//virtual void ImpWiz::SetColDesignations(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols)
virtual void ImpWiz::SetColDesignations(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols, int nFirstSourceCol) // = 0
///---END PARTIAL_DESIGNATIOINS
{
		///////////////////////////////////////////////////////
		// The follwoing will construct the designation strings.
		///////////////////////////////////////////////////////
		// Start with the designations in the filter.
		string strColDesig = fuGetDesignations(trFilter);
		///---Sim 05-08-2007 FIX_DEFAULT_SHOULD_NOT_CHAGNE_DESIGNATIONS
		if ( strColDesig.IsEmpty() ) // not need to change
			return;
		///---END FIX_DEFAULT_SHOULD_NOT_CHAGNE_DESIGNATIONS
		
		bool bRepetitive = fuGetRepetitive(trFilter);
		
		///---Sim 08-09-2006 PARTIAL_DESIGNATIOINS
		/*
		if ( nFirstTargetCol + strColDesig.GetLength() >= wks.GetNumCols() )
		{
			// When the col designation have equal or more cols than the wks
			// just add front of existing settings into current existing setting.
			string strExistColDesig = wks.GetColDesignations();
			strExistColDesig.Delete(nFirstTargetCol, strExistColDesig.GetLength() - nFirstTargetCol);
			strColDesig.Insert(0, strExistColDesig);
		}
		else
		{
			// When the col designation strings have less cols than the wks
			// we need to append the current existing settings to avoid having our
			// last setting repeating and overwriting the existing settings.
		*/
		string strTmp = wks.GetColDesignations();
		//GetColumnSetting(strTmp, strColDesig, nFirstTargetCol, nCols, bRepetitive);
		GetColumnSetting(strTmp, strColDesig, nFirstTargetCol, nCols, bRepetitive, nFirstSourceCol);
		strColDesig = strTmp;
		//}
		///---END PARTIAL_DESIGNATIOINS
		
		m_bRepetitive = bRepetitive;
		m_strColDesig = strColDesig;
		wks.SetColDesignations(strColDesig, bRepetitive);
}

///---Sim 08-08-2006 PARTIAL_DESIGNATIOINS
//virtual void ImpWiz::SetColFormats(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols)
virtual void ImpWiz::SetColFormats(Worksheet& wks, TreeNode& trFilter, int nFirstTargetCol, int nCols, int nFirstSourceCol) // = 0
///---END PARTIAL_DESIGNATIOINS
{
		///////////////////////////////////////////////////////
		// The follwoing will construct the format strings.
		///////////////////////////////////////////////////////
		// Start with the format in the filter.
		string strColFormat = fuGetFormats(trFilter);
		bool bRepetitive = fuGetRepetitive(trFilter);
		
		///---Sim 08-09-2006 PARTIAL_DESIGNATIOINS
		/*
		if ( nFirstTargetCol + strColFormat.GetLength() >= wks.GetNumCols() )
		{
			// When the col format have equal or more cols than the wks
			// just add front of existing settings into current existing setting.
			string strExistColFormat = wks.GetColFormats();
			strExistColFormat.Delete(nFirstTargetCol, strExistColFormat.GetLength() - nFirstTargetCol);
			strColFormat.Insert(0, strExistColFormat);
		}
		else
		{
			// When the col format strings have less cols than the wks
			// we need to append the current existing settings to avoid having our
			// last setting repeating and overwriting the existing settings.
		*/
		string strTmp = wks.GetColFormats();
		//GetColumnSetting(strTmp, strColFormat, nFirstTargetCol, nCols, bRepetitive);
		GetColumnSetting(strTmp, strColFormat, nFirstTargetCol, nCols, bRepetitive, nFirstSourceCol);
		strColFormat = strTmp;
		//}
		///---END PARTIAL_DESIGNATIOINS

		m_bRepetitive = bRepetitive;
		m_strColFormat = strColFormat;
		wks.SetColFormats(strColFormat, bRepetitive);
}
///---END COMMON_FUNC_ON_BASE_CLASS

/// AW 08/03/06 MORE_ON_IW_IMPORT

virtual int ImpWiz::PrepareWksColsForImport(Layer &lyTarget, TreeNode &trFilter) 
{  
	///---Sim 08-04-2006 COMMON_FUNC_ON_BASE_CLASS
	Worksheet wks(lyTarget);
	if( !wks )
		/// 08/09/06 AW CHECK_IW_FILTER 
		//return IMPERR_PREPARE_WKS; // error, no worksheet
		return IMPERR_NONE;
		/// END CHECK_IW_FILTER
	
	///////////////////////////////////////////////////////
	// The following (switch on filter type) will set nCols
	// to the number of columns in the data file.
	// This number may not always be correct, but should be
	// sufficient for setting up the wks columns.
	//
	// It may be easier/safer to use the ColDesignations or
	// ColFormats setting in the filter.  I will look into
	// this later.
	///////////////////////////////////////////////////////
	int nCols = GetColNumberFromFilter(trFilter);

	///////////////////////////////////////////////////
	// The following will adjust nCols based on the
	// partial import settings.
	///////////////////////////////////////////////////
	///---Sim 08-30-2006 GET_FILTER_BY_ID
	int nFirstSourceCol = 0;
	int nLastSourceCol = -1;
	//if( trFilter.Common.Partial.nVal )
	if( fuGetInt(trFilter, IDE_IMP_PARTIAL, 0) )
	{
		//nFirstSourceCol = trFilter.Common.PartialC1.nVal;
		nFirstSourceCol = fuGetInt(trFilter, IDE_IMP_PARTIALC1, 0);
		nLastSourceCol = fuGetInt(trFilter, IDE_IMP_PARTIALC2, -1);
		
		//if( nFirstSourceCol > trFilter.Common.PartialC2.nVal )
		if( nFirstSourceCol > nLastSourceCol )
			nCols -= nFirstSourceCol;
		else
			//nCols = trFilter.Common.PartialC2.nVal - nFirstSourceCol + 1;
			nCols = nLastSourceCol - nFirstSourceCol + 1;
	}
	///---END GET_FILTER_BY_ID
	
	///////////////////////////////////////////////////
	// The following (switch on import mode) will
	// adjust nCols based on the import mode.
	///////////////////////////////////////////////////
	int nFirstTargetCol = 0;
	int nNumExistingCols = wks.GetNumCols();
	int nNewCols = 0;
	switch( fuGetImportMode(trFilter) )
	{
	case ASCIMP_MODE_REPLACE_DATA:
	case ASCIMP_MODE_APPEND_ROWS:
	case ASCIMP_MODE_NEW_BOOKS:
	case ASCIMP_MODE_NEW_SHEETS:
	case ASCIMP_MODE_AUTO:
		if( nCols > nNumExistingCols )
			nNewCols = nCols - nNumExistingCols;
		break;
	case ASCIMP_MODE_APPEND_COLS:
		nFirstTargetCol = wks_find_empty_column(wks);
		 
		if( nFirstTargetCol >= 0 )
		{
			nNewCols = nCols - (nNumExistingCols - nFirstTargetCol);
		}
		else // no empty columns
		{
			nFirstTargetCol = nNumExistingCols;
			nNewCols = nCols;
		}
		break;
	}
	/// Hong 0314/08 QA80-10989 FIX_LOCK_RANGE_CHECK_EXPAND_FOR_ONE_COLUMN
	//if( wks.IsWriteProtected(nFirstTargetCol, nFirstTargetCol + nCols) )
	if( wks.IsWriteProtected(nFirstTargetCol, nFirstTargetCol + nCols - 1) )
	/// end FIX_LOCK_RANGE_CHECK_EXPAND_FOR_ONE_COLUMN
	{
		/// Hong QA80-10989 IMPORT_SHOULD_STOP_AND_TAKE_NO_EFFECT_IF_COL_LOCKED
		/*
		if( IDNO == MessageBox(GetWindow(),
			_L("The data's target window has a locked column.\nDo you want to continue import?"),
			_L("File Import"), MB_YESNO) )
		{
			return IMPERR_CANCEL_ON_LOCKED_COL;
		}
		*/
		//return XFERR_WORKSHEET_HAS_COL_LOCKED;
		/// Hong 01/09/09 v8.0995 CORRECT_IMPASC_ERROR_RETURN_CHECKING
		//return ERR_WKS_COL_LOCKED; /// Hong 03/06/08, refer to EJP 2008-02-26 v8.0812 QA80-4808 STOP_IMPORT_IF_ANY_COLS_ARE_LOCKED in impasc.oxf
		return IMPERR_WKS_HAS_COL_LOCKED;
		/// end CORRECT_IMPASC_ERROR_RETURN_CHECKING
		/// end IMPORT_SHOULD_STOP_AND_TAKE_NO_EFFECT_IF_COL_LOCKED
	}
	
	string str;
	
	if( nNewCols > 0 )
	{		
		/// Hong 09/10/07 v8.0699b FIX_FAIL_ADD_NEW_COL_TO_CORRECT_WORKSHEET
		/*
		Page pgTarget;
		lyTarget.GetParent(pgTarget);
		str.Format("work -a %d", nNewCols);
		pgTarget.LT_execute(str);		
		*/
		wks.SetSize(-1, nNumExistingCols + nNewCols);
		/// end FIX_FAIL_ADD_NEW_COL_TO_CORRECT_WORKSHEET
	}					
	
	/// AW 08/06/06 CHECK_IW_FILTER
	///---Sim 08-08-2006 SPECIAL_FORMATS_IN_ASCII recover
	//SetColDesignations(wks, trFilter, nFirstTargetCol, nCols);
	//SetColFormats(wks, trFilter, nFirstTargetCol, nCols);
	SetColDesignations(wks, trFilter, nFirstTargetCol, nCols, nFirstSourceCol);
	/// Hong 04/11/07 v8.0598 MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
	if ( !fuIsKeepTargetColFormat(trFilter) )
	/// end MORE_OPTION_FOR_WHETHER_APPLY_COL_FORMAT
		SetColFormats(wks, trFilter, nFirstTargetCol, nCols, nFirstSourceCol);
	///---END SPECIAL_FORMATS_IN_ASCII
	
	///---Sim 08-08-2006 SPECIAL_FORMATS_IN_ASCII
	/*
	string strColDesig = fuGetDesignations(trFilter);
	string strColFormat = fuGetFormats(trFilter);

	if( nFirstSourceCol )
	{
		strColDesig.Delete(0, nFirstSourceCol);
		strColFormat.Delete(0, nFirstSourceCol);
	}
	
	bool bRepetitive = fuGetRepetitive(trFilter);
		
	if ( nFirstTargetCol + strColDesig.GetLength() >= wks.GetNumCols() )
	{
		// When the col designation have equal or more cols than the wks
		// just add front of existing settings into current existing setting.
		string strExistColDesig = wks.GetColDesignations();
		strExistColDesig.Delete(nFirstTargetCol, strExistColDesig.GetLength() - nFirstTargetCol);
		strColDesig.Insert(0, strExistColDesig);
	}
	else
	{
		// When the col designation strings have less cols than the wks
		// we need to append the current existing settings to avoid having our
		// last setting repeating and overwriting the existing settings.
		string strTmp = wks.GetColDesignations();
		GetColumnSetting(strTmp, strColDesig, nFirstTargetCol, nCols, bRepetitive);
		strColDesig = strTmp;
	}
	
	m_bRepetitive = bRepetitive;
	m_strColDesig = strColDesig;
	wks.SetColDesignations(strColDesig, bRepetitive);
	
	
	if ( nFirstTargetCol + strColFormat.GetLength() >= wks.GetNumCols() )
	{
		// When the col format have equal or more cols than the wks
		// just add front of existing settings into current existing setting.
		string strExistColFormat = wks.GetColFormats();
		strExistColFormat.Delete(nFirstTargetCol, strExistColFormat.GetLength() - nFirstTargetCol);
		strColFormat.Insert(0, strExistColFormat);
	}
	else
	{
		// When the col format strings have less cols than the wks
		// we need to append the current existing settings to avoid having our
		// last setting repeating and overwriting the existing settings.
		string strTmp = wks.GetColFormats();
		GetColumnSetting(strTmp, strColFormat, nFirstTargetCol, nCols, bRepetitive);
		strColFormat = strTmp;
	}
	
	m_bRepetitive = bRepetitive;
	m_strColFormat = strColFormat;
	wks.SetColFormats(strColFormat, bRepetitive);
	
	string strCustomFormat;
	if( fuGetCustomDate(trFilter, strCustomFormat) )
	{
		Column col;
		int nIndex = strColFormat.Find('3', 0); // column formats - Date	(3)
		while( nIndex >= 0 )
		{
			col = wks.Columns(nIndex);
			if( col )
			{
				Tree tr;
				if( info_get_section(col, tr, "system.display") )
				{
					tr.CustomFormat.strVal = strCustomFormat;
					info_set_section(col, tr, "system.display");
				}
				col.SetSubFormat(LDF_OBJ_CUSTOM);
			}
			nIndex = strColFormat.Find('3', nIndex + 1);
		}
		
	}
	*/
	///---END SPECIAL_FORMATS_IN_ASCII
	/// END CHECK_IW_FILTER
	
	return IMPERR_NONE;
	///---END COMMON_FUNC_ON_BASE_CLASS
}
///---Sim 02-26-2007 ADD_FILE_NAME_TO_COL_COMMENT
//virtual void ImpWiz::RenameTarget( string& strFullFileName, Layer& lyTarget, Page& pgTarget, TreeNode &trFilter )
virtual void ImpWiz::RenameTarget( string& strFullFileName, DataRange& drTarget, TreeNode &trFilter )
///---END ADD_FILE_NAME_TO_COL_COMMENT
{
	///---Sim 01-29-2007 SUPPORT_AUTO_RENAME
	/*
	string strNewName = GetFileName(strFullFileName, TRUE);
	if( !strNewName.IsEmpty() )
	{
		bool bRenameWks, bRenameWkBk, bIncludePath;
		if ( !getRenameMode(trFilter, &bRenameWks, &bIncludePath, &bRenameWkBk) )
			return;
		
		//if( lyTarget && fuIsRenameWks(trFilter) )
		if( lyTarget && bRenameWks )
			lyTarget.SetName(strNewName);

		///---Sim 01-24-2007 SHOW_FULL_FILE_NAME_WITH_PATH_IN_WORKBOOK_TITLE
		if ( pgTarget )
		{
			// rename short name
			//if( fuIsRenameWorkbook(trFilter) )
			if( bRenameWkBk )
				pgTarget.Rename(strNewName);
			
			// rename long name
			//strNewName = strFullFileName;
			//if( fuIsAppendFileNameWithoutPath(trFilter) )
				//strNewName = GetFileName(strFullFileName, FALSE);
			if ( bIncludePath )
				strNewName = strFullFileName;	
			pgTarget.SetLongName(strNewName);
		}
		///---END SHOW_FULL_FILE_NAME_WITH_PATH_IN_WORKBOOK_TITLE
	}		
	*/
	/// Hong 08/26/09 QA80-13839-P1 FIX_IMPASC_REIMPORT_APPEND_REDUNDANT_FILENAME_INTO_PG_COMMENT
	//setPageAndLayerName(drTarget, strFullFileName, trFilter);
	DWORD 		dwCtrl = m_bReimport ? COVER_LAST_ADDED_COMMENT : 0;
	setPageAndLayerName(drTarget, strFullFileName, trFilter, dwCtrl);
	/// end FIX_IMPASC_REIMPORT_APPEND_REDUNDANT_FILENAME_INTO_PG_COMMENT
	///---END SUPPORT_AUTO_RENAME
}
virtual void ImpWiz::SetPageInfo(Page& pgTarget, TreeNode& trFilter, string& strFileName)
{
	okutil_SetPageInfo(pgTarget.GetName(), strFileName, m_iFilterType);	
}

/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
//virtual BOOL ImpWiz::ImportHeaderVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter)
virtual BOOL ImpWiz::ImportHeaderVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter, StringArray* psaVarNiceNames) // = NULL
/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
{	
	/// Hong 9/26/06 ADD_VARIABLE_TO_PAGE_INFO
	//return false;
	switch( fuGetType(tnFilter) )
	{
	case FILTER_TYPE_ASCII:		
		/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
		//return import_variables_from_ascii_file(saVarNames, saVarValues, lpcszDataFile, tnFilter);		
		return import_variables_from_ascii_file(saVarNames, saVarValues, lpcszDataFile, tnFilter, psaVarNiceNames);
		/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	case FILTER_TYPE_BINARY:		
		/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
		//return import_binary_header_variables(saVarNames, saVarValues, lpcszDataFile, tnFilter);
		return import_binary_header_variables(saVarNames, saVarValues, lpcszDataFile, tnFilter, psaVarNiceNames);
		/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	case FILTER_TYPE_USERDEFINED:
		return false; // not implemented
	}
	return false;
	/// END ADD_VARIABLE_TO_PAGE_INFO
}

/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
//virtual BOOL ImpWiz::ImportFileNameVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter)
virtual BOOL ImpWiz::ImportFileNameVars(StringArray& saVarNames, StringArray& saVarValues, LPCSTR lpcszDataFile, const TreeNode& tnFilter, StringArray* psaVarNiceNames) // = NULL
/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
{
	/// Hong 9/26/06 ADD_VARIABLE_TO_PAGE_INFO
	//return false;
	/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	//return get_variables_from_data_file(saVarNames, saVarValues, lpcszDataFile, tnFilter, TRUE); // TRUE == from file name
	return get_variables_from_data_file(saVarNames, saVarValues, lpcszDataFile, tnFilter, TRUE, psaVarNiceNames); // TRUE == from file name
	/// end /// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	/// END ADD_VARIABLE_TO_PAGE_INFO
}

virtual void ImpWiz::GetWksColInfo(Layer& lyTarget)
{
	Worksheet wks(lyTarget);
	if ( wks )
	{
		m_strColDesig = wks.GetColDesignations();
		m_strColFormat = wks.GetColFormats();
		m_bRepetitive = false; ///---Sim 08-04-2006 RECORD_COL_DESIG_FORMAT_REPETITIVE
	}
}
virtual void ImpWiz::SetWksColInfo(Page& pgTarget)
{
	Worksheet wks(pgTarget.GetName());
	if ( wks && FILTER_TYPE_USERDEFINED != m_iFilterType)
	{
		string strColDesig = wks.GetColDesignations();  //test
		string strColFormat = wks.GetColFormats();		//test
		
		///---Sim 08-04-2006 RECORD_COL_DESIG_FORMAT_REPETITIVE
		//wks.SetColDesignations(m_strColDesig, false);
		//wks.SetColFormats(m_strColFormat, false);
		wks.SetColDesignations(m_strColDesig, m_bRepetitive);
		wks.SetColFormats(m_strColFormat, m_bRepetitive);
		///---END RECORD_COL_DESIG_FORMAT_REPETITIVE
	}
}

void ImpWiz::SetPageLayer(Page& pgTarget, Layer& lyTarget, TreeNode &trFilter, string& strFullFileName, TreeNode& trImpInfo)
{
	BOOL		bGenerateImpInfo = !fuIsNotSaveImportInfoToPage(trFilter); /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED

	///---Sim 01-31-2007 ADD_AUTO_RENAME
	// must rename firstly before range info is save to page
	//RenameTarget(strFullFileName, lyTarget, pgTarget, trFilter);
	/// AW 08/15/07 NEED_CHECK_PGTARGET_IN_IMPORTING
	if (!lyTarget.IsValid() )
	{
		//out_str("Invalid Layer!");
		return;
	}
	else
	{
		if ( !pgTarget.IsValid() )
			pgTarget = 	lyTarget.GetPage();
	}
	/// END NEED_CHECK_PGTARGET_IN_IMPORTING
	DataRange dr;
	TreeNode trRange = tree_get_node_by_tagname(trImpInfo, "DataRange", true);
	if ( trRange )
	{
		///---Sim 03-11-2007 QA80-9435 CENTRALIZE_RANGE_TREE_BOTH_ON_VC_AND_OC
		//TreeNode trRangeUID = trRange.GetNode("RangeUID");
		//if ( trRangeUID )
			//dr = (DataRange)Project.GetObject(trRangeUID.nVal);	
		//
		/////---Sim 03-07-2007 REMOVE_BOOK_NAME_FROM_RANGE_STRING
		//TreeNode trRangeStr = trRange.GetNode("Range");
		//if ( trRangeStr )
		//{
			//if ( dr )
				//trRangeStr.strVal = dr.GetDescription(GETLC_PAGE_NAME_NONE|GETLC_COL_SHORT_NAME|GETLC_NO_DESIGNATIONS);
		//}
		/////---END REMOVE_BOOK_NAME_FROM_RANGE_STRING
		
		// temporary fix
		if ( trRange.Datarange )
			trRange = trRange.Datarange;
		
		dr = get_and_check_range(trRange);
		///---END QA80-9435 CENTRALIZE_RANGE_TREE_BOTH_ON_VC_AND_OC
	}			
	if ( dr )
	/// Hong 04/12/07 v8.0599 ADD_REIMPORT_SUPPORT_FOR_IMP_WIZ
	{
		RenameTarget(strFullFileName, dr, trFilter);
		/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		//if ( !m_bReimport )
		if ( !m_bReimport && bGenerateImpInfo )
		/// end ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
			impinfo_UpdateExistingData(pgTarget, dr);
	}
	/// Hong 14/05/08 v8.0862b FIX_IMP_WIZ_NOT_AUTOSIZE_WORKSHEET_AS_OTHER_IMP_TOOL
	Worksheet wks(lyTarget);
	if ( wks )
	{
		///---Sim 12-28-2009 QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
		/*
		///Jasmine 08/14/09 QA81-14148 AUTOSIZE_BETTER_HEIGHT_AND_WIDTH
		//wks.AutoSize(AS_INVALIDATE | AS_NOHEIGHT);
		OGRIDLIMITS limits;
		init_autosize_limits(&limits, 10, -1, -1, -1);//10 to limit the row min width
		limits.col.nCount = -1;// resize all cols
		limits.row.dwCntrl = OLC_SKIP_HIDDEN|OLC_NO_MARGIN|OLC_SKIP_HEADER;	///Jasmine 08/21/09 QA81-14148 AUTOSIZE_SKIP_COL_HEADER
		limits.col.dwCntrl = OLC_SKIP_HIDDEN;
		///------ Folger 08/19/09 QA80-14148 SUPPORT_SKIP_SPECIFIC_LABELS_WHEN_AUTOSIZE_WKS
		vector<int>		vnLabelTypes = {
			RCLT_SPARKLINE
		};
		limits.labelsToSkip.pnTypes = vnLabelTypes;
		limits.labelsToSkip.nCount = vnLabelTypes.GetSize();
		///------ End SUPPORT_SKIP_SPECIFIC_LABELS_WHEN_AUTOSIZE_WKS
		wks.AutoSize(0, 0, &limits);
		///End AUTOSIZE_BETTER_HEIGHT_AND_WIDTH
		
		wks.Invalidate();
		*/
		///---Sim 01-05-2010 QA81-14895 ADD_LT_VAR_FOR_DEFAULT_COUNTS_OF_AUTOSIZE_COLS
		//fu_autosize_rowcol(wks, trFilter, 10, -1, -1, -1, -1, OLC_SKIP_HIDDEN, OLC_SKIP_HIDDEN|OLC_NO_MARGIN|OLC_SKIP_HEADER);
		fu_autosize_rowcol(wks, trFilter, 10, -1, -1, -1, 0, OLC_SKIP_HIDDEN, OLC_SKIP_HIDDEN|OLC_NO_MARGIN|OLC_SKIP_HEADER);
		///---END QA81-14895 ADD_LT_VAR_FOR_DEFAULT_COUNTS_OF_AUTOSIZE_COLS
		///---END QA81-14895 SPEED_UP_81_IMP_WIZ_ASC
	}
	/// end FIX_IMP_WIZ_NOT_AUTOSIZE_WORKSHEET_AS_OTHER_IMP_TOOL
	
	
	//GenerateImpInfo(strFullFileName, pgTarget, trFilter, trImpInfo);
	int nFNodeIndex; // which file node need to update
	if ( bGenerateImpInfo ) /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		GenerateImpInfo(strFullFileName, pgTarget, trFilter, trImpInfo, nFNodeIndex);
	/// end ADD_REIMPORT_SUPPORT_FOR_IMP_WIZ

	//RenameTarget(strFullFileName, lyTarget, pgTarget, trFilter);
	///---END ADD_AUTO_RENAME
	
	StringArray saVarNames, saVarValues;
	/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME	
	StringArray 	*psaVarNiceNames = NULL, *psaFNameVarNiceNames = NULL;
	StringArray 	saVarNiceNames, saFNameVarNiceNames;		
	const bool		bSaveVarToUDL = fuIsVarInUDL(trFilter);
	/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR		
	//if ( bSaveVarToUDL )
	bool			bShowNiceName = false;
#ifdef		GUI_SHOW_NICE_NAME
	bShowNiceName = true;
#endif		//GUI_SHOW_NICE_NAME
	if ( bSaveVarToUDL || bShowNiceName )
	/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
	{
		psaVarNiceNames = &saVarNiceNames;
		psaFNameVarNiceNames = &saFNameVarNiceNames;
	}
	/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME	
	/// Hong 01/15/07 RESET_USER_VARIABLES
	pgTarget.Info.User.RemoveSection("Variables");
	pgTarget.Info.Remove("User");
	
	/// end RESET_USER_VARIABLES	
	/// Hong 02/26/07 FIX_SHOULD_NOT_SORT_VARIABLE
	/*
	if  ( ImportHeaderVars(saVarNames, saVarValues, strFullFileName, trFilter) )
	{
		impinfo_HeaderVariablesToFileNode(m_trFile, saVarNames, saVarValues);
		if( fuIsVarInPageInfo(trFilter) )
			HeaderVariablesToPageInfo(pgTarget, saVarNames, saVarValues);

		// Reset arrays before importing file name variables
		saVarNames.SetSize(0); // Remove header variable names
		saVarValues.SetSize(0); // Remove header variable values
	}

	if ( ImportFileNameVars(saVarNames, saVarValues, strFullFileName, trFilter) )
	{
		impinfo_FileNameVariablesToFileNode(m_trFile, saVarNames, saVarValues);
		if( fuIsVarInPageInfo(trFilter) )
			HeaderVariablesToPageInfo(pgTarget, saVarNames, saVarValues);
	}
	*/
	/// Hong 03/30/07 v8.0593 ROLLBACK_CODE_TO_SORT_VARIABLE_BY_FILENAME_HEADER
	/*
	// all variable will be extract in one function, no need to do sort, keep user's order is better
	if ( ImportHeaderVars(saVarNames, saVarValues, strFullFileName, trFilter) )
	{
		impinfo_HeaderVariablesToFileNode(m_trFile, saVarNames, saVarValues);
		if( fuIsVarInPageInfo(trFilter) )
			HeaderVariablesToPageInfo(pgTarget, saVarNames, saVarValues);
	*/
	/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	if ( ImportHeaderVars(saVarNames, saVarValues, strFullFileName, trFilter, psaVarNiceNames) )
	/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	{	
		/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
		//impinfo_HeaderVariablesToFileNode(m_trFile, saVarNames, saVarValues);
		if ( bGenerateImpInfo ) /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		{
			StringArray		*psaVarLabels = bShowNiceName ? psaVarNiceNames : NULL;
			impinfo_HeaderVariablesToFileNode(m_trFile, saVarNames, saVarValues, psaVarLabels);
		}
		/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR	
	}	
	
	StringArray saFNameVarNames, saFNameVarValues;
	/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	//if ( ImportFileNameVars(saFNameVarNames, saFNameVarValues, strFullFileName, trFilter) )	
	if ( ImportFileNameVars(saFNameVarNames, saFNameVarValues, strFullFileName, trFilter, psaFNameVarNiceNames) )
	/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	{
		/// Hong 08/12/08 QA80-11980 VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
		if ( bGenerateImpInfo ) /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		{
			StringArray		*psaFileNameVarLabels = bShowNiceName ? saFNameVarNames : NULL;
			impinfo_FileNameVariablesToFileNode(m_trFile, saFNameVarNames, saFNameVarValues, psaFileNameVarLabels);		
		}
		/// end VARIABLE_ALWAYS_SHOW_NICE_NAME_IN_GUI_ASKED_BY_EASWAR
		saVarNames.Append(saFNameVarNames);
		saVarValues.Append(saFNameVarValues);
		/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
		if ( bSaveVarToUDL )
		{
			ASSERT(psaVarNiceNames && psaFNameVarNiceNames);
			psaVarNiceNames->Append(*psaFNameVarNiceNames);
		}
		/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	}
	
	if( fuIsVarInPageInfo(trFilter) )
		HeaderVariablesToPageInfo(pgTarget, saVarNames, saVarValues);
	/// end ROLLBACK_CODE_TO_SORT_VARIABLE_BY_FILENAME_HEADER
	
	/// Hong 08/08/08 QA80-11980 SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	if ( bSaveVarToUDL )
	/// Hong 08/11/08 QA80-11980 VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
		//HeaderVariablesToUserDefinedParameter(dr, saVarNames, saVarValues);
	{			
		ASSERT(psaVarNiceNames);
		if ( 0 == psaVarNiceNames->GetSize() )
			*psaVarNiceNames = saVarNames;
		HeaderVariablesToUserDefinedParameter(dr, *psaVarNiceNames, saVarValues);
	}
	/// end VARAIBLE_TO_USER_PARAMETER_USING_NICE_NAME
	/// end SAVE_IMPORT_EXTRACTED_VARIABLE_IN_USER_DEFINED_PARAMETERS
	
	///---Sim 03-06-2007 MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	if( !fuIsAutoRename(trFilter) )
	{
		/// Hong 02/26/07 ADD_WORKSHEET_TO_FIRST_VARIABLE 
		//if( !fuIsAutoRename(trFilter) && fuIsRenameWksWithVar(trFilter) )
		/// Hong 03/30/07 v8.0593 ROLLBACK_CODE_TO_SORT_VARIABLE_BY_FILENAME_HEADER
		//if( fuIsRenameWksWithVar(trFilter) )
		if( saVarNames.GetSize() > 0 && fuIsRenameWksWithVar(trFilter) )
		/// end ROLLBACK_CODE_TO_SORT_VARIABLE_BY_FILENAME_HEADER
		/// Hong 02/27/07 QA80-9410 MORE_RENAME_WORKSHEET_WITH_VARIABLE
		//	lyTarget.SetName(saVarValues[0], OCD_ENUM_NEXT);
		{
			string strVarName, strSheetName;
			if( fuGetRenameWksVarName(trFilter, strVarName) )
			{
				int nIndex = saVarNames.Find(strVarName);
				if(nIndex != -1)
				{
					strSheetName = saVarValues[nIndex];
					lyTarget.SetName(strSheetName, OCD_ENUM_NEXT);
				}
			}
		}
		/// end MORE_RENAME_WORKSHEET_WITH_VARIABLE
		/// end ADD_WORKSHEET_TO_FIRST_VARIABLE
		/// Hong 03/30/07 v8.0593 ROLLBACK_CODE_TO_SORT_VARIABLE_BY_FILENAME_HEADER
		//if( fuIsRenameWkbkWithVar(trFilter) )
		if( saVarNames.GetSize() > 0 && fuIsRenameWkbkWithVar(trFilter) )
		/// end ROLLBACK_CODE_TO_SORT_VARIABLE_BY_FILENAME_HEADER
		{
			string strVarName, strBookName;
			if( fuGetRenameWkbkVarName(trFilter, strVarName) )
			{
				int nIndex = saVarNames.Find(strVarName);
				if(nIndex != -1)
				{
					strBookName = saVarValues[nIndex];
					pgTarget.SetLongName(strBookName);
				}
			}
		}
	}
	///---END MORE_RENAME_WKBK_TRIM_FNAME_FOR_XF
	//} // Hong 03/30/07 v8.0593 ROLLBACK_CODE_TO_SORT_VARIABLE_BY_FILENAME_HEADER
	/// end FIX_SHOULD_NOT_SORT_VARIABLE 
	
	///---Sim 01-31-2007 ADD_AUTO_RENAME
	/*
	if( fuIsAppendFileNameToWorkBookComments(trFilter) )
	{
		string strFileName;
		if( fuIsAppendFileNameWithoutPath(trFilter) )
			strFileName = GetFileName(strFullFileName);
		else
			strFileName = strFullFileName;
		
		string strComments;
		strComments = pgTarget.GetComments();
		if( !strComments.IsEmpty() )
			strComments += "\r\n";
		strComments += strFileName;
		pgTarget.SetComments(strComments);
	}
	*/
	///---END ADD_AUTO_RENAME
	
	SetPageInfo(pgTarget, trFilter, strFullFileName);
	
	/// EJP 2008-06-09 v8.0881 EXECUTE_SCRIPT_IN_IMPORT_FILTER_AFTER_UPDATING_PAGE_INFO
	// The following block was moved to after setting/updating import info to
	// allow accessing the import info from within the import filter post script.
	/*
	string strLTScript;
	if( fuGetPostImportScript(trFilter, strLTScript) && !strLTScript.IsEmpty() )
	{
		Layer lay = pgTarget.Layers();
		if( lay )
			lay.LT_execute(strLTScript);
	}
	*/
	/// end EXECUTE_SCRIPT_IN_IMPORT_FILTER_AFTER_UPDATING_PAGE_INFO
	/// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
	if ( bGenerateImpInfo )
	{
	/// end ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED

		/// Hong 04/12/07 v8.0599 ADD_REIMPORT_SUPPORT_FOR_IMP_WIZ
		//bool bOK = impinfo_SetLastFileNode(pgTarget, m_trFile);
		bool bOK;
		if( !m_bReimport )
		{
			bOK = impinfo_SetLastFileNode(pgTarget, m_trFile);
		}
		else
		{
			bOK = impinfo_UpdateFileNode(pgTarget, m_trFile, nFNodeIndex);
		}
		/// end ADD_REIMPORT_SUPPORT_FOR_IMP_WIZ
	
		/// Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
		/*
		/// EJP 2008-06-09 v8.0881 EXECUTE_SCRIPT_IN_IMPORT_FILTER_AFTER_UPDATING_PAGE_INFO
		// The following block was moved to here from before the setting/updating import info
		//  to allow accessing the import info from within the import filter post script.
		string strLTScript;
		if( fuGetPostImportScript(trFilter, strLTScript) && !strLTScript.IsEmpty() )
		{
			Layer lay = pgTarget.Layers();
			if( lay )
				lay.LT_execute(strLTScript);
		}
		/// end EXECUTE_SCRIPT_IN_IMPORT_FILTER_AFTER_UPDATING_PAGE_INFO
		*/
		/// end FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
		
		///---Sim 06-25-2007 UPDATE_ORGANIZER
		char szBuffer[MAXLINE];
		int nNodeIndex = string_to_prefix_end_number(szBuffer, m_trFile.tagName);
		///Folger 06/26/07 CHANGE_UPDATE_TO_NOTIFY
		//update_organizer_gui(pgTarget, UPDATE_FROM_IMPORT, nNodeIndex);
		notify_organizer_gui(pgTarget, UPDATE_FROM_IMPORT, nNodeIndex);
		///End CHANGE_UPDATE_TO_NOTIFY
		//refresh_organizer_gui(pgTarget); /// Hong 10/24/07 v8.0732 IMPROVE_ORGANIZER_REFRESH_BY_ONIDLE
		///---END UPDATE_ORGANIZER
	
	#ifdef	_DEBUG /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		/// testing
		Tree trTemp;
		bOK = impinfo_GetLastFileNode(pgTarget, trTemp);
	#endif	//_DEBUG /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
		ASSERT(bOK);
	} /// Hong 07/07/10 ORG-491 ASC_ADD_OPTION_NOT_GENERATE_FILTER_TREE_TO_IMPROVE_IMP_SPEED
}

/// Hong 07/21/08 QA80-11869 FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII
//virtual
void	ImpWiz::AfterImport(const Layer& lyTarget, LPCSTR lpszFileName, const TreeNode& trFilter, TreeNode& tnInfo)
{
	Page 	pgData;
	if ( lyTarget )
		lyTarget.GetParent(pgData);	
	SetPageLayer(pgData, lyTarget, trFilter, lpszFileName, tnInfo);
	
	IWBase::AfterImport(lyTarget, lpszFileName, trFilter, tnInfo);
}
/// end FIX_FILTER_SCRIPT_FAIL_RUN_WHEN_DRAG_AND_DROP_EXCEPT_ASCII